<?php
require_once '../../config/config.php';
require_once '../../config/auth.php';
require_once '../../config/database.php';
require_once '../../helpers/format_uang.php';

require_once '../../templates/header.php';
require_once '../../templates/sidebar.php';

// Hitung aset
$kas = $db->query("SELECT SUM(total) AS kas FROM kasir_transaksi")->fetch_assoc()['kas'];
$simpanan = $db->query("SELECT SUM(jumlah) AS simpanan FROM simpanan_transaksi")->fetch_assoc()['simpanan'];
$piutang = $db->query("SELECT SUM(sisa_pinjaman) AS piutang FROM pinjaman")->fetch_assoc()['piutang'];

// Hitung kewajiban
$hutang = 0;

// Modal (sementara)
$modal = ($kas + $simpanan + $piutang) - $hutang;
?>

<h2>Neraca Koperasi</h2>

<table class="table">
    <tr>
        <th colspan="2">ASET</th>
    </tr>
    <tr>
        <td>Kas</td>
        <td><?= format_uang($kas); ?></td>
    </tr>
    <tr>
        <td>Simpanan Anggota</td>
        <td><?= format_uang($simpanan); ?></td>
    </tr>
    <tr>
        <td>Piutang Pinjaman</td>
        <td><?= format_uang($piutang); ?></td>
    </tr>

    <tr>
        <th colspan="2">KEWAJIBAN</th>
    </tr>
    <tr>
        <td>Hutang</td>
        <td><?= format_uang($hutang); ?></td>
    </tr>

    <tr>
        <th colspan="2">MODAL</th>
    </tr>
    <tr>
        <td>Modal Bersih</td>
        <td><?= format_uang($modal); ?></td>
    </tr>
</table>

<?php require_once '../../templates/footer.php'; ?>
